//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.QueryUserTeamResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 用户下级分销关系查询 */
public class QueryUserTeamRequest extends AntCloudProdRequest<QueryUserTeamResponse> {
  private String itemId;

  private Long pageNum;

  private Long pageSize;

  @NotNull
  private String shopId;

  @NotNull
  private String userId;

  public QueryUserTeamRequest(String productInstanceId) {
    super("baas.distribution.user.team.query", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public QueryUserTeamRequest() {
    super("baas.distribution.user.team.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 商品唯一标识 */
  public String getItemId() {
    return this.itemId;
  }

  /**
   * 商品唯一标识 */
  public void setItemId(String itemId) {
    this.itemId = itemId;
  }

  /**
   * 分页查询当前页号，默认值1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 分页查询当前页号，默认值1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页查询当前页大小，默认值20 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页查询当前页大小，默认值20 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 商户唯一标识 */
  public String getShopId() {
    return this.shopId;
  }

  /**
   * 商户唯一标识 */
  public void setShopId(String shopId) {
    this.shopId = shopId;
  }

  /**
   * 用户唯一标识 */
  public String getUserId() {
    return this.userId;
  }

  /**
   * 用户唯一标识 */
  public void setUserId(String userId) {
    this.userId = userId;
  }
}
