//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.QueryTxCheckResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 通过额交易hash查询，返回hash对应区块链上信息。 */
public class QueryTxCheckRequest extends AntCloudProdRequest<QueryTxCheckResponse> {
  private String bizType;

  private String payloadHash;

  @NotNull
  private String source;

  private String subTitle;

  private String title;

  @NotNull
  private String txHash;

  public QueryTxCheckRequest(String productInstanceId) {
    super("baas.traceability.tx.check.query", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public QueryTxCheckRequest() {
    super("baas.traceability.tx.check.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 接入业务标识，一接入方有条链或者必须区分统计业务类型情况下必填。 */
  public String getBizType() {
    return this.bizType;
  }

  /**
   * 接入业务标识，一接入方有条链或者必须区分统计业务类型情况下必填。 */
  public void setBizType(String bizType) {
    this.bizType = bizType;
  }

  /**
   * 溯源信息内容校验码用sha256hex(内容) 计算出其正确性。 */
  public String getPayloadHash() {
    return this.payloadHash;
  }

  /**
   * 溯源信息内容校验码用sha256hex(内容) 计算出其正确性。 */
  public void setPayloadHash(String payloadHash) {
    this.payloadHash = payloadHash;
  }

  /**
   * 区块链接入来源 */
  public String getSource() {
    return this.source;
  }

  /**
   * 区块链接入来源 */
  public void setSource(String source) {
    this.source = source;
  }

  /**
   * 区块查证信息透传 */
  public String getSubTitle() {
    return this.subTitle;
  }

  /**
   * 区块查证信息透传 */
  public void setSubTitle(String subTitle) {
    this.subTitle = subTitle;
  }

  /**
   * 透传到查证结果的标题信息 */
  public String getTitle() {
    return this.title;
  }

  /**
   * 透传到查证结果的标题信息 */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * 要查询的区块链交易信息。 */
  public String getTxHash() {
    return this.txHash;
  }

  /**
   * 要查询的区块链交易信息。 */
  public void setTxHash(String txHash) {
    this.txHash = txHash;
  }
}
