//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.QueryRiskFourmetaResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 四要素验证身份冒用风险
 */
public class QueryRiskFourmetaRequest extends AntCloudProdRequest<QueryRiskFourmetaResponse> {
  @NotNull
  private String bankCardNo;

  @NotNull
  private String certNo;

  @NotNull
  private String mobile;

  @NotNull
  private String name;

  public QueryRiskFourmetaRequest(String productInstanceId) {
    super("baas.identification.risk.fourmeta.query", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public QueryRiskFourmetaRequest() {
    super("baas.identification.risk.fourmeta.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 被核验人银行卡号 */
  public String getBankCardNo() {
    return this.bankCardNo;
  }

  /**
   * 被核验人银行卡号 */
  public void setBankCardNo(String bankCardNo) {
    this.bankCardNo = bankCardNo;
  }

  /**
   * 被核验人身份证号码 */
  public String getCertNo() {
    return this.certNo;
  }

  /**
   * 被核验人身份证号码 */
  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  /**
   * 被核验人手机号码 */
  public String getMobile() {
    return this.mobile;
  }

  /**
   * 被核验人手机号码 */
  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  /**
   * 被核验人姓名 */
  public String getName() {
    return this.name;
  }

  /**
   * 被核验人姓名 */
  public void setName(String name) {
    this.name = name;
  }
}
