//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.QueryMappingResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 查询商户下账户在链上账号映射情况 */
public class QueryMappingRequest extends AntCloudProdRequest<QueryMappingResponse> {
  @NotNull
  private String bizid;

  @NotNull
  private String uid;

  public QueryMappingRequest(String productInstanceId) {
    super("baas.account.mapping.query", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public QueryMappingRequest() {
    super("baas.account.mapping.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 要映射的链对应的唯一id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 要映射的链对应的唯一id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 自有系统中该账户唯一标示 */
  public String getUid() {
    return this.uid;
  }

  /**
   * 自有系统中该账户唯一标示 */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
