//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.QueryBrowserPrivilegeResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 查询租户查看某链的权限 */
public class QueryBrowserPrivilegeRequest extends AntCloudProdRequest<QueryBrowserPrivilegeResponse> {
  @NotNull
  private String bizid;

  @NotNull
  private String tenantid;

  public QueryBrowserPrivilegeRequest(String productInstanceId) {
    super("baas.blockchain.browser.privilege.query", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public QueryBrowserPrivilegeRequest() {
    super("baas.blockchain.browser.privilege.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 链id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 链id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 租户id */
  public String getTenantid() {
    return this.tenantid;
  }

  /**
   * 租户id */
  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }
}
