//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.IdentityParam;
import cn.com.antcloud.api.blockchain.v1_0_0.response.InitTransactionResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 初始化存证事务: 进⾏行行资格核验，包括调⽤用⽅方账号权限，是否实⼈人等。成功后获得存证事务 ID(Token) */
public class InitTransactionRequest extends AntCloudProdRequest<InitTransactionResponse> {
  @NotNull
  private IdentityParam customer;

  private String properties;

  private IdentityParam trustee;

  private Boolean tsr;

  public InitTransactionRequest(String productInstanceId) {
    super("baas.notary.transaction.init", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public InitTransactionRequest() {
    super("baas.notary.transaction.init", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 客户的身份信息 */
  public IdentityParam getCustomer() {
    return this.customer;
  }

  /**
   * 客户的身份信息 */
  public void setCustomer(IdentityParam customer) {
    this.customer = customer;
  }

  /**
   * 扩展字段 */
  public String getProperties() {
    return this.properties;
  }

  /**
   * 扩展字段 */
  public void setProperties(String properties) {
    this.properties = properties;
  }

  /**
   * 托管用户信息 */
  public IdentityParam getTrustee() {
    return this.trustee;
  }

  /**
   * 托管用户信息 */
  public void setTrustee(IdentityParam trustee) {
    this.trustee = trustee;
  }

  /**
   * 是否使⽤用可信时间戳，默认为false */
  public Boolean getTsr() {
    return this.tsr;
  }

  /**
   * 是否使⽤用可信时间戳，默认为false */
  public void setTsr(Boolean tsr) {
    this.tsr = tsr;
  }
}
