//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.GetRawTextResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 获取原生存证内容接口 */
public class GetRawTextRequest extends AntCloudProdRequest<GetRawTextResponse> {
  @NotNull
  private String bizid;

  @NotNull
  private String transactionHash;

  public GetRawTextRequest(String productInstanceId) {
    super("baas.notary.raw.text.get", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public GetRawTextRequest() {
    super("baas.notary.raw.text.get", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 区块链的唯一性标示 */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 区块链的唯一性标示 */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 存证哈希 */
  public String getTransactionHash() {
    return this.transactionHash;
  }

  /**
   * 存证哈希 */
  public void setTransactionHash(String transactionHash) {
    this.transactionHash = transactionHash;
  }
}
