//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CreateUserResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建用户接口 */
public class CreateUserRequest extends AntCloudProdRequest<CreateUserResponse> {
  @NotNull
  private String identity;

  private String info;

  @NotNull
  private String mobile;

  @NotNull
  private String source;

  public CreateUserRequest(String productInstanceId) {
    super("baas.distribution.user.create", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public CreateUserRequest() {
    super("baas.distribution.user.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 用户在ISV中的唯一标识 */
  public String getIdentity() {
    return this.identity;
  }

  /**
   * 用户在ISV中的唯一标识 */
  public void setIdentity(String identity) {
    this.identity = identity;
  }

  /**
   * 其他说明 */
  public String getInfo() {
    return this.info;
  }

  /**
   * 其他说明 */
  public void setInfo(String info) {
    this.info = info;
  }

  /**
   * 用户手机号码 */
  public String getMobile() {
    return this.mobile;
  }

  /**
   * 用户手机号码 */
  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  /**
   * 来源: 微信朋友圈/微信小程序/支付宝小程序/H5/商户自有APP/其他 */
  public String getSource() {
    return this.source;
  }

  /**
   * 来源: 微信朋友圈/微信小程序/支付宝小程序/H5/商户自有APP/其他 */
  public void setSource(String source) {
    this.source = source;
  }
}
