//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CreateShopResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建商户接口 */
public class CreateShopRequest extends AntCloudProdRequest<CreateShopResponse> {
  @NotNull
  private String identity;

  private String info;

  @NotNull
  private String name;

  public CreateShopRequest(String productInstanceId) {
    super("baas.distribution.shop.create", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public CreateShopRequest() {
    super("baas.distribution.shop.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 商户在ISV中的标识 */
  public String getIdentity() {
    return this.identity;
  }

  /**
   * 商户在ISV中的标识 */
  public void setIdentity(String identity) {
    this.identity = identity;
  }

  /**
   * 其他说明 */
  public String getInfo() {
    return this.info;
  }

  /**
   * 其他说明 */
  public void setInfo(String info) {
    this.info = info;
  }

  /**
   * 商户名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 商户名称 */
  public void setName(String name) {
    this.name = name;
  }
}
