//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CreateRawTextResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 原生存证接口 */
public class CreateRawTextRequest extends AntCloudProdRequest<CreateRawTextResponse> {
  private String accountId;

  @NotNull
  private String bizid;

  @NotNull
  private String content;

  public CreateRawTextRequest(String productInstanceId) {
    super("baas.notary.raw.text.create", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public CreateRawTextRequest() {
    super("baas.notary.raw.text.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 如果已经在链上有账户，可以直接使用已有的账户进行存证。如果为空，服务端会在链上创建一个 */
  public String getAccountId() {
    return this.accountId;
  }

  /**
   * 如果已经在链上有账户，可以直接使用已有的账户进行存证。如果为空，服务端会在链上创建一个 */
  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  /**
   * 链的唯一性标示，请联系baas平台获取 */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 链的唯一性标示，请联系baas平台获取 */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 存证内容 */
  public String getContent() {
    return this.content;
  }

  /**
   * 存证内容 */
  public void setContent(String content) {
    this.content = content;
  }
}
