//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CreateExchangeEpstockissueResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台版通存量发行接口 */
public class CreateExchangeEpstockissueRequest extends AntCloudProdRequest<CreateExchangeEpstockissueResponse> {
  @NotNull
  private String epCode;

  @NotNull
  private String epIssueAccount;

  @NotNull
  private Long epOfflineIssueAmount;

  @NotNull
  private Long epOnlineIssueAmount;

  @NotNull
  private Long epSelfIssueAmount;

  @NotNull
  private String exchangeCode;

  public CreateExchangeEpstockissueRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.epstockissue.create", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public CreateExchangeEpstockissueRequest() {
    super("baas.digitalasset.exchange.epstockissue.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 版通发行方账户 */
  public String getEpIssueAccount() {
    return this.epIssueAccount;
  }

  /**
   * 版通发行方账户 */
  public void setEpIssueAccount(String epIssueAccount) {
    this.epIssueAccount = epIssueAccount;
  }

  /**
   * 版通存量发行线下量 */
  public Long getEpOfflineIssueAmount() {
    return this.epOfflineIssueAmount;
  }

  /**
   * 版通存量发行线下量 */
  public void setEpOfflineIssueAmount(Long epOfflineIssueAmount) {
    this.epOfflineIssueAmount = epOfflineIssueAmount;
  }

  /**
   * 版通存量发行线上量 */
  public Long getEpOnlineIssueAmount() {
    return this.epOnlineIssueAmount;
  }

  /**
   * 版通存量发行线上量 */
  public void setEpOnlineIssueAmount(Long epOnlineIssueAmount) {
    this.epOnlineIssueAmount = epOnlineIssueAmount;
  }

  /**
   * 版通存量发行自持量 */
  public Long getEpSelfIssueAmount() {
    return this.epSelfIssueAmount;
  }

  /**
   * 版通存量发行自持量 */
  public void setEpSelfIssueAmount(Long epSelfIssueAmount) {
    this.epSelfIssueAmount = epSelfIssueAmount;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }
}
