//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CheckRiskTextResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 文本内容安全扫描 */
public class CheckRiskTextRequest extends AntCloudProdRequest<CheckRiskTextResponse> {
  @NotNull
  private String content;

  public CheckRiskTextRequest(String productInstanceId) {
    super("baas.content.risk.text.check", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public CheckRiskTextRequest() {
    super("baas.content.risk.text.check", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 文本内容 */
  public String getContent() {
    return this.content;
  }

  /**
   * 文本内容 */
  public void setContent(String content) {
    this.content = content;
  }
}
