//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.AccountInfoWithBiz;
import cn.com.antcloud.api.blockchain.v1_0_0.response.BatchcreateMappingInfoResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 批量创建用户信息 */
public class BatchcreateMappingInfoRequest extends AntCloudProdRequest<BatchcreateMappingInfoResponse> {
  @NotNull
  private List<AccountInfoWithBiz> list;

  public BatchcreateMappingInfoRequest(String productInstanceId) {
    super("baas.account.mapping.info.batchcreate", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public BatchcreateMappingInfoRequest() {
    super("baas.account.mapping.info.batchcreate", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 批量上传的用户信息 */
  public List<AccountInfoWithBiz> getList() {
    return this.list;
  }

  /**
   * 批量上传的用户信息 */
  public void setList(List<AccountInfoWithBiz> list) {
    this.list = list;
  }
}
