//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.ExchangeAccountMap;
import cn.com.antcloud.api.blockchain.v1_0_0.response.BatchcreateExchangeAccountmapResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台用户账户批量映射接口 */
public class BatchcreateExchangeAccountmapRequest extends AntCloudProdRequest<BatchcreateExchangeAccountmapResponse> {
  @NotNull
  private List<ExchangeAccountMap> accountMapParams;

  @NotNull
  private String exchangeCode;

  public BatchcreateExchangeAccountmapRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.accountmap.batchcreate", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public BatchcreateExchangeAccountmapRequest() {
    super("baas.digitalasset.exchange.accountmap.batchcreate", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 业务方需映射的账户列表 */
  public List<ExchangeAccountMap> getAccountMapParams() {
    return this.accountMapParams;
  }

  /**
   * 业务方需映射的账户列表 */
  public void setAccountMapParams(List<ExchangeAccountMap> accountMapParams) {
    this.accountMapParams = accountMapParams;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }
}
