//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 存证元数据 */
public class NotaryMetaParam {
  @NotNull
  private String phase;

  private String properties;

  @NotNull
  private String token;

  /**
   * 描述本条存证在存证事务中的阶段，用户可自行维护 */
  public String getPhase() {
    return this.phase;
  }

  /**
   * 描述本条存证在存证事务中的阶段，用户可自行维护 */
  public void setPhase(String phase) {
    this.phase = phase;
  }

  /**
   * 扩展字段 */
  public String getProperties() {
    return this.properties;
  }

  /**
   * 扩展字段 */
  public void setProperties(String properties) {
    this.properties = properties;
  }

  /**
   * 全局唯一的存证事务ID */
  public String getToken() {
    return this.token;
  }

  /**
   * 全局唯一的存证事务ID */
  public void setToken(String token) {
    this.token = token;
  }
}
