//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.model;

import java.lang.Long;
import javax.validation.constraints.NotNull;

/**
 * 版通历史发行记录信息 */
public class EPIssueHisInfo {
  @NotNull
  private Long issueDate;

  @NotNull
  private Long offlineIssueAmount;

  @NotNull
  private Long onlineIssueAmount;

  @NotNull
  private Long selfIssueAmount;

  /**
   * 版通发行日期时间戳 */
  public Long getIssueDate() {
    return this.issueDate;
  }

  /**
   * 版通发行日期时间戳 */
  public void setIssueDate(Long issueDate) {
    this.issueDate = issueDate;
  }

  /**
   * 版通线下发行量 */
  public Long getOfflineIssueAmount() {
    return this.offlineIssueAmount;
  }

  /**
   * 版通线下发行量 */
  public void setOfflineIssueAmount(Long offlineIssueAmount) {
    this.offlineIssueAmount = offlineIssueAmount;
  }

  /**
   * 版通线上发行量 */
  public Long getOnlineIssueAmount() {
    return this.onlineIssueAmount;
  }

  /**
   * 版通线上发行量 */
  public void setOnlineIssueAmount(Long onlineIssueAmount) {
    this.onlineIssueAmount = onlineIssueAmount;
  }

  /**
   * 版通自持发行量 */
  public Long getSelfIssueAmount() {
    return this.selfIssueAmount;
  }

  /**
   * 版通自持发行量 */
  public void setSelfIssueAmount(Long selfIssueAmount) {
    this.selfIssueAmount = selfIssueAmount;
  }
}
