//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * did doc 中的扩展服务定义 */
public class DidServiceType {
  @NotNull
  private String keyName;

  @NotNull
  private String keyValue;

  @NotNull
  private String serviceType;

  /**
   * 目前必须是endPoint */
  public String getKeyName() {
    return this.keyName;
  }

  /**
   * 目前必须是endPoint */
  public void setKeyName(String keyName) {
    this.keyName = keyName;
  }

  /**
   * 该扩展字段如何取值，目前这个字段会作为keyName从extension的json里获取对应的值 */
  public String getKeyValue() {
    return this.keyValue;
  }

  /**
   * 该扩展字段如何取值，目前这个字段会作为keyName从extension的json里获取对应的值 */
  public void setKeyValue(String keyValue) {
    this.keyValue = keyValue;
  }

  /**
   * 自定义服务的类型，为了保证全局唯一，真实展示时，添加前缀 */
  public String getServiceType() {
    return this.serviceType;
  }

  /**
   * 自定义服务的类型，为了保证全局唯一，真实展示时，添加前缀 */
  public void setServiceType(String serviceType) {
    this.serviceType = serviceType;
  }
}
