//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.UpdateVerifiableclaimStatusResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 更新可验证声明状态 */
public class UpdateVerifiableclaimStatusRequest extends AntCloudProdRequest<UpdateVerifiableclaimStatusResponse> {
  @NotNull
  private String status;

  @NotNull
  private String vcId;

  public UpdateVerifiableclaimStatusRequest(String productInstanceId) {
    super("baas.did.verifiableclaim.status.update", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public UpdateVerifiableclaimStatusRequest() {
    super("baas.did.verifiableclaim.status.update", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 希望可验证声明的状态， 0无效，1生效 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 希望可验证声明的状态， 0无效，1生效 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 可验证声明id */
  public String getVcId() {
    return this.vcId;
  }

  /**
   * 可验证声明id */
  public void setVcId(String vcId) {
    this.vcId = vcId;
  }
}
