//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StopProductResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 用户资源到期或欠费情况下会对资源先进行停服操作，用于限制用户使用但不能删除用户数据！不同的产品可以根据自身的功能进行不同的限制。 */
public class StopProductRequest extends AntCloudProdRequest<StopProductResponse> {
  @NotNull
  private String instanceId;

  @NotNull
  private String orderNo;

  @NotNull
  private String productCode;

  public StopProductRequest(String productInstanceId) {
    super("baas.ocp.product.stop", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public StopProductRequest() {
    super("baas.ocp.product.stop", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 产品实例Id */
  public String getInstanceId() {
    return this.instanceId;
  }

  /**
   * 产品实例Id */
  public void setInstanceId(String instanceId) {
    this.instanceId = instanceId;
  }

  /**
   * 订单号用于业务串联，以及幂等。目前为纯数字。保留使用大小写英文字符可能。 */
  public String getOrderNo() {
    return this.orderNo;
  }

  /**
   * 订单号用于业务串联，以及幂等。目前为纯数字。保留使用大小写英文字符可能。 */
  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  /**
   * 产品码 全局唯一 */
  public String getProductCode() {
    return this.productCode;
  }

  /**
   * 产品码 全局唯一 */
  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }
}
