//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartSignatureResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 为用户生成签名的接口 */
public class StartSignatureRequest extends AntCloudProdRequest<StartSignatureResponse> {
  @NotNull
  private String algorithm;

  @NotNull
  private String bizid;

  @NotNull
  private String data;

  @NotNull
  private String uid;

  public StartSignatureRequest(String productInstanceId) {
    super("baas.account.signature.start", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public StartSignatureRequest() {
    super("baas.account.signature.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 加密算法 */
  public String getAlgorithm() {
    return this.algorithm;
  }

  /**
   * 加密算法 */
  public void setAlgorithm(String algorithm) {
    this.algorithm = algorithm;
  }

  /**
   * 区块链唯一标示 */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 区块链唯一标示 */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 用户需要签名的原始数据 */
  public String getData() {
    return this.data;
  }

  /**
   * 用户需要签名的原始数据 */
  public void setData(String data) {
    this.data = data;
  }

  /**
   * 签名账户在原系统中的唯一标示 */
  public String getUid() {
    return this.uid;
  }

  /**
   * 签名账户在原系统中的唯一标示 */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
