//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.AccountMap;
import cn.com.antcloud.api.blockchain.v1_0_0.response.StartMappingResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 将用户自有账户导入到链上 */
public class StartMappingRequest extends AntCloudProdRequest<StartMappingResponse> {
  @NotNull
  private AccountMap account;

  @NotNull
  private String extension;

  public StartMappingRequest(String productInstanceId) {
    super("baas.account.mapping.start", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public StartMappingRequest() {
    super("baas.account.mapping.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 映射账户详细信息 */
  public AccountMap getAccount() {
    return this.account;
  }

  /**
   * 映射账户详细信息 */
  public void setAccount(AccountMap account) {
    this.account = account;
  }

  /**
   * 扩展信息 */
  public String getExtension() {
    return this.extension;
  }

  /**
   * 扩展信息 */
  public void setExtension(String extension) {
    this.extension = extension;
  }
}
