//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartExchangeUnfreezeResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台版通解限接口 */
public class StartExchangeUnfreezeRequest extends AntCloudProdRequest<StartExchangeUnfreezeResponse> {
  @NotNull
  private String epCode;

  @NotNull
  private Long epUnfreezeAmount;

  @NotNull
  private String exchangeCode;

  @NotNull
  private String userAccount;

  public StartExchangeUnfreezeRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.unfreeze.start", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public StartExchangeUnfreezeRequest() {
    super("baas.digitalasset.exchange.unfreeze.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 解限数量 */
  public Long getEpUnfreezeAmount() {
    return this.epUnfreezeAmount;
  }

  /**
   * 解限数量 */
  public void setEpUnfreezeAmount(Long epUnfreezeAmount) {
    this.epUnfreezeAmount = epUnfreezeAmount;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }

  /**
   * 业务方用户账户 */
  public String getUserAccount() {
    return this.userAccount;
  }

  /**
   * 业务方用户账户 */
  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }
}
