//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartExchangeLockpositionResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台资源管理 处理用户、版通的锁定与解锁
 * 1. ep_code有值，user_account为空时，对指定版通进行锁定解锁操作
 * 2. ep_code为空，user_account有值时，对指定账户进行锁定解锁操作
 * 3. ep_code，user_account均有值时，对指定账户的版通进行锁定解锁操作
 * 4. ep_code，user_account均为空时，对全交易所进行锁定解锁操作，需谨慎 */
public class StartExchangeLockpositionRequest extends AntCloudProdRequest<StartExchangeLockpositionResponse> {
  private String epCode;

  @NotNull
  private String exchangeCode;

  @NotNull
  private Long operate;

  private String userAccount;

  public StartExchangeLockpositionRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.lockposition.start", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public StartExchangeLockpositionRequest() {
    super("baas.digitalasset.exchange.lockposition.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }

  /**
   * 锁定操作，0为解锁，1为锁定 */
  public Long getOperate() {
    return this.operate;
  }

  /**
   * 锁定操作，0为解锁，1为锁定 */
  public void setOperate(Long operate) {
    this.operate = operate;
  }

  /**
   * 业务方账户 */
  public String getUserAccount() {
    return this.userAccount;
  }

  /**
   * 业务方账户 */
  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }
}
