//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartCorporateSelfcreateResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;

/**
 * 直接创建自己的企业did */
public class StartCorporateSelfcreateRequest extends AntCloudProdRequest<StartCorporateSelfcreateResponse> {
  private String ownerName;

  public StartCorporateSelfcreateRequest(String productInstanceId) {
    super("baas.did.corporate.selfcreate.start", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public StartCorporateSelfcreateRequest() {
    super("baas.did.corporate.selfcreate.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 公司名称 */
  public String getOwnerName() {
    return this.ownerName;
  }

  /**
   * 公司名称 */
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }
}
