//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.NotaryMetaParam;
import cn.com.antcloud.api.blockchain.v1_0_0.response.SendTransactionTextResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 发起⼀个文本存证，将文本内容存证上链。 */
public class SendTransactionTextRequest extends AntCloudProdRequest<SendTransactionTextResponse> {
  @NotNull
  private NotaryMetaParam meta;

  @NotNull
  private String notaryContent;

  private Boolean tsr;

  public SendTransactionTextRequest(String productInstanceId) {
    super("baas.notary.transaction.text.send", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public SendTransactionTextRequest() {
    super("baas.notary.transaction.text.send", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 存证元数据 */
  public NotaryMetaParam getMeta() {
    return this.meta;
  }

  /**
   * 存证元数据 */
  public void setMeta(NotaryMetaParam meta) {
    this.meta = meta;
  }

  /**
   * 存证内容 */
  public String getNotaryContent() {
    return this.notaryContent;
  }

  /**
   * 存证内容 */
  public void setNotaryContent(String notaryContent) {
    this.notaryContent = notaryContent;
  }

  /**
   * 是否使用可信时间戳 */
  public Boolean getTsr() {
    return this.tsr;
  }

  /**
   * 是否使用可信时间戳 */
  public void setTsr(Boolean tsr) {
    this.tsr = tsr;
  }
}
