//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.QueryExchangeEptradeResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台交易查询接口
 * 1. ep_code有值，user_account为空时，查询版通的交易信息
 * 2. ep_code为空，user_account有值时，查询账户的交易信息
 * 3. ep_code，user_account均有值时，查询账户下指定版通的交易信息 */
public class QueryExchangeEptradeRequest extends AntCloudProdRequest<QueryExchangeEptradeResponse> {
  @NotNull
  private String endDate;

  private String epCode;

  @NotNull
  private String exchangeCode;

  @NotNull
  private Long pageNum;

  @NotNull
  private Long pageSize;

  @NotNull
  private String startDate;

  private String userAccount;

  public QueryExchangeEptradeRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.eptrade.query", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public QueryExchangeEptradeRequest() {
    super("baas.digitalasset.exchange.eptrade.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 查询截止时间 */
  public String getEndDate() {
    return this.endDate;
  }

  /**
   * 查询截止时间 */
  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  /**
   * 版通代码 （版通代码与用户账户至少选一个） */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 （版通代码与用户账户至少选一个） */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }

  /**
   * 页数 从1开始 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 页数 从1开始 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 每页显示数量 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页显示数量 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 查询起始时间 */
  public String getStartDate() {
    return this.startDate;
  }

  /**
   * 查询起始时间 */
  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  /**
   * 用户账户 （版通代码与用户账户至少选一个） */
  public String getUserAccount() {
    return this.userAccount;
  }

  /**
   * 用户账户 （版通代码与用户账户至少选一个） */
  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }
}
