//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.QueryBlockchainInfosResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 通过链id，获取链的相关信息 */
public class QueryBlockchainInfosRequest extends AntCloudProdRequest<QueryBlockchainInfosResponse> {
  @NotNull
  private String bizid;

  public QueryBlockchainInfosRequest(String productInstanceId) {
    super("baas.traceability.blockchain.infos.query", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public QueryBlockchainInfosRequest() {
    super("baas.traceability.blockchain.infos.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 区块链id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 区块链id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }
}
