//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.GetUserbizkeyResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 获取用户的密钥对。
 * 公钥为明文公钥
 * 私钥为密文，需要用户在本地再做一次解密才能得到真正的私钥 */
public class GetUserbizkeyRequest extends AntCloudProdRequest<GetUserbizkeyResponse> {
  @NotNull
  private String bizid;

  @NotNull
  private String keyName;

  public GetUserbizkeyRequest(String productInstanceId) {
    super("baas.akdf.userbizkey.get", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public GetUserbizkeyRequest() {
    super("baas.akdf.userbizkey.get", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 区块链id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 区块链id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 密钥名称 */
  public String getKeyName() {
    return this.keyName;
  }

  /**
   * 密钥名称 */
  public void setKeyName(String keyName) {
    this.keyName = keyName;
  }
}
