//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CreateProductResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建实例 */
public class CreateProductRequest extends AntCloudProdRequest<CreateProductResponse> {
  private String customData;

  @NotNull
  private String instanceIds;

  @NotNull
  private String orderNo;

  @NotNull
  private String productCode;

  private String region;

  @NotNull
  private String specification;

  private String workspace;

  private String zones;

  public CreateProductRequest(String productInstanceId) {
    super("baas.ocp.product.create", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public CreateProductRequest() {
    super("baas.ocp.product.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 部分产品创建时需要非生产规格的数据（JSON格式）  */
  public String getCustomData() {
    return this.customData;
  }

  /**
   * 部分产品创建时需要非生产规格的数据（JSON格式）  */
  public void setCustomData(String customData) {
    this.customData = customData;
  }

  /**
   * 产品实例Id	 */
  public String getInstanceIds() {
    return this.instanceIds;
  }

  /**
   * 产品实例Id	 */
  public void setInstanceIds(String instanceIds) {
    this.instanceIds = instanceIds;
  }

  /**
   * 订单号用于业务串联，以及幂等。目前为纯数字。保留使用大小写英文字符可能。 */
  public String getOrderNo() {
    return this.orderNo;
  }

  /**
   * 订单号用于业务串联，以及幂等。目前为纯数字。保留使用大小写英文字符可能。 */
  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  /**
   * 产品码 全局唯一 */
  public String getProductCode() {
    return this.productCode;
  }

  /**
   * 产品码 全局唯一 */
  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  /**
   * 地域 */
  public String getRegion() {
    return this.region;
  }

  /**
   * 地域 */
  public void setRegion(String region) {
    this.region = region;
  }

  /**
   * 具体规格配置信息（JSON格式）会按照key进行排序 */
  public String getSpecification() {
    return this.specification;
  }

  /**
   * 具体规格配置信息（JSON格式）会按照key进行排序 */
  public void setSpecification(String specification) {
    this.specification = specification;
  }

  /**
   * 环境唯一标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境唯一标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }

  /**
   * 可用区	 */
  public String getZones() {
    return this.zones;
  }

  /**
   * 可用区	 */
  public void setZones(String zones) {
    this.zones = zones;
  }
}
