//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CreateExchangeEpissueResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台版通发行接口 */
public class CreateExchangeEpissueRequest extends AntCloudProdRequest<CreateExchangeEpissueResponse> {
  @NotNull
  private String epAnchor;

  @NotNull
  private String epCode;

  @NotNull
  private Long epFirstAmount;

  @NotNull
  private String epIssueAccount;

  @NotNull
  private Long epIssueDate;

  @NotNull
  private String epName;

  @NotNull
  private Long epOfflineIssueAmount;

  @NotNull
  private Long epOfflineUnfreeze;

  @NotNull
  private Long epOnlineIssueAmount;

  @NotNull
  private Long epSelfAmount;

  @NotNull
  private Long epSelfUnfreeze;

  @NotNull
  private Long epTotalAmount;

  @NotNull
  private String epType;

  @NotNull
  private String exchangeCode;

  private String extend;

  public CreateExchangeEpissueRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.epissue.create", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public CreateExchangeEpissueRequest() {
    super("baas.digitalasset.exchange.epissue.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 版通锚定物 */
  public String getEpAnchor() {
    return this.epAnchor;
  }

  /**
   * 版通锚定物 */
  public void setEpAnchor(String epAnchor) {
    this.epAnchor = epAnchor;
  }

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 版通首发量 */
  public Long getEpFirstAmount() {
    return this.epFirstAmount;
  }

  /**
   * 版通首发量 */
  public void setEpFirstAmount(Long epFirstAmount) {
    this.epFirstAmount = epFirstAmount;
  }

  /**
   * 版通发行方账户 */
  public String getEpIssueAccount() {
    return this.epIssueAccount;
  }

  /**
   * 版通发行方账户 */
  public void setEpIssueAccount(String epIssueAccount) {
    this.epIssueAccount = epIssueAccount;
  }

  /**
   * 版通发行时间戳 */
  public Long getEpIssueDate() {
    return this.epIssueDate;
  }

  /**
   * 版通发行时间戳 */
  public void setEpIssueDate(Long epIssueDate) {
    this.epIssueDate = epIssueDate;
  }

  /**
   * 版通名称 */
  public String getEpName() {
    return this.epName;
  }

  /**
   * 版通名称 */
  public void setEpName(String epName) {
    this.epName = epName;
  }

  /**
   * 版通线下发行配额 */
  public Long getEpOfflineIssueAmount() {
    return this.epOfflineIssueAmount;
  }

  /**
   * 版通线下发行配额 */
  public void setEpOfflineIssueAmount(Long epOfflineIssueAmount) {
    this.epOfflineIssueAmount = epOfflineIssueAmount;
  }

  /**
   * 版通线下日解限比例 */
  public Long getEpOfflineUnfreeze() {
    return this.epOfflineUnfreeze;
  }

  /**
   * 版通线下日解限比例 */
  public void setEpOfflineUnfreeze(Long epOfflineUnfreeze) {
    this.epOfflineUnfreeze = epOfflineUnfreeze;
  }

  /**
   * 版通线上发行配额 */
  public Long getEpOnlineIssueAmount() {
    return this.epOnlineIssueAmount;
  }

  /**
   * 版通线上发行配额 */
  public void setEpOnlineIssueAmount(Long epOnlineIssueAmount) {
    this.epOnlineIssueAmount = epOnlineIssueAmount;
  }

  /**
   * 发行方版通自持量 */
  public Long getEpSelfAmount() {
    return this.epSelfAmount;
  }

  /**
   * 发行方版通自持量 */
  public void setEpSelfAmount(Long epSelfAmount) {
    this.epSelfAmount = epSelfAmount;
  }

  /**
   * 发行方版通日解限比例 */
  public Long getEpSelfUnfreeze() {
    return this.epSelfUnfreeze;
  }

  /**
   * 发行方版通日解限比例 */
  public void setEpSelfUnfreeze(Long epSelfUnfreeze) {
    this.epSelfUnfreeze = epSelfUnfreeze;
  }

  /**
   * 版通发行数量 */
  public Long getEpTotalAmount() {
    return this.epTotalAmount;
  }

  /**
   * 版通发行数量 */
  public void setEpTotalAmount(Long epTotalAmount) {
    this.epTotalAmount = epTotalAmount;
  }

  /**
   * 版通类型 */
  public String getEpType() {
    return this.epType;
  }

  /**
   * 版通类型 */
  public void setEpType(String epType) {
    this.epType = epType;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }

  /**
   * 预留扩展字段 */
  public String getExtend() {
    return this.extend;
  }

  /**
   * 预留扩展字段 */
  public void setExtend(String extend) {
    this.extend = extend;
  }
}
