//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.AccountMap;
import cn.com.antcloud.api.blockchain.v1_0_0.response.BatchcreateMappingResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 自有账户到链上账户的批量映射接口 */
public class BatchcreateMappingRequest extends AntCloudProdRequest<BatchcreateMappingResponse> {
  @NotNull
  private List<AccountMap> data;

  public BatchcreateMappingRequest(String productInstanceId) {
    super("baas.account.mapping.batchcreate", "1.0", "Java-SDK-20190620", productInstanceId);
  }

  public BatchcreateMappingRequest() {
    super("baas.account.mapping.batchcreate", "1.0", null);
    this.setSdkVersion("Java-SDK-20190620");
  }

  /**
   * 待映射处理的账户信息列表 */
  public List<AccountMap> getData() {
    return this.data;
  }

  /**
   * 待映射处理的账户信息列表 */
  public void setData(List<AccountMap> data) {
    this.data = data;
  }
}
