//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台版通交易信息 */
public class EPTradeInfo {
  @NotNull
  private String epCode;

  @NotNull
  private String txCode;

  @NotNull
  private String txFrom;

  @NotNull
  private Long txTime;

  @NotNull
  private String txTo;

  @NotNull
  private Long txValue;

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 版通交易号 */
  public String getTxCode() {
    return this.txCode;
  }

  /**
   * 版通交易号 */
  public void setTxCode(String txCode) {
    this.txCode = txCode;
  }

  /**
   * 卖方账户 */
  public String getTxFrom() {
    return this.txFrom;
  }

  /**
   * 卖方账户 */
  public void setTxFrom(String txFrom) {
    this.txFrom = txFrom;
  }

  /**
   * 交易时间戳 */
  public Long getTxTime() {
    return this.txTime;
  }

  /**
   * 交易时间戳 */
  public void setTxTime(Long txTime) {
    this.txTime = txTime;
  }

  /**
   * 买方账户 */
  public String getTxTo() {
    return this.txTo;
  }

  /**
   * 买方账户 */
  public void setTxTo(String txTo) {
    this.txTo = txTo;
  }

  /**
   * 交易数量 */
  public Long getTxValue() {
    return this.txValue;
  }

  /**
   * 交易数量 */
  public void setTxValue(Long txValue) {
    this.txValue = txValue;
  }
}
