//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.response;

import cn.com.antcloud.api.blockchain.v1_0_0.model.DistributionUser;
import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Long;
import java.util.List;

/**
 * 用户下级分销关系查询 */
public class QueryUserTeamResponse extends AntCloudProdResponse {
  private List<DistributionUser> members;

  private Long memberNum;

  private Long oneLevelMemberNum;

  private Long pageNum;

  private Long pageSize;

  private Long twoLevelMemberNum;

  /**
   * 一级会员信息 */
  public List<DistributionUser> getMembers() {
    return this.members;
  }

  /**
   * 一级会员信息 */
  public void setMembers(List<DistributionUser> members) {
    this.members = members;
  }

  /**
   * 下级用户总数 */
  public Long getMemberNum() {
    return this.memberNum;
  }

  /**
   * 下级用户总数 */
  public void setMemberNum(Long memberNum) {
    this.memberNum = memberNum;
  }

  /**
   * 一级会员数 */
  public Long getOneLevelMemberNum() {
    return this.oneLevelMemberNum;
  }

  /**
   * 一级会员数 */
  public void setOneLevelMemberNum(Long oneLevelMemberNum) {
    this.oneLevelMemberNum = oneLevelMemberNum;
  }

  /**
   * 分页查询当前页号 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 分页查询当前页号 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页查询当前页大小 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页查询当前页大小 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 二级会员数 */
  public Long getTwoLevelMemberNum() {
    return this.twoLevelMemberNum;
  }

  /**
   * 二级会员数 */
  public void setTwoLevelMemberNum(Long twoLevelMemberNum) {
    this.twoLevelMemberNum = twoLevelMemberNum;
  }
}
