//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartVerifiableclaimVerifierResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 验证可验证声明 */
public class StartVerifiableclaimVerifierRequest extends AntCloudProdRequest<StartVerifiableclaimVerifierResponse> {
  @NotNull
  private String verifiableClaim;

  public StartVerifiableclaimVerifierRequest(String productInstanceId) {
    super("baas.did.verifiableclaim.verifier.start", "1.0", "Java-SDK-20190613", productInstanceId);
  }

  public StartVerifiableclaimVerifierRequest() {
    super("baas.did.verifiableclaim.verifier.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190613");
  }

  /**
   * 可验证声明 */
  public String getVerifiableClaim() {
    return this.verifiableClaim;
  }

  /**
   * 可验证声明 */
  public void setVerifiableClaim(String verifiableClaim) {
    this.verifiableClaim = verifiableClaim;
  }
}
