//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.BareClaim;
import cn.com.antcloud.api.blockchain.v1_0_0.response.StartVerifiableclaimIssureResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 使用自己或者代理的did为指定did颁发证书 */
public class StartVerifiableclaimIssureRequest extends AntCloudProdRequest<StartVerifiableclaimIssureResponse> {
  @NotNull
  private BareClaim bareClaim;

  @NotNull
  private String issuer;

  @NotNull
  private String subject;

  public StartVerifiableclaimIssureRequest(String productInstanceId) {
    super("baas.did.verifiableclaim.issure.start", "1.0", "Java-SDK-20190613", productInstanceId);
  }

  public StartVerifiableclaimIssureRequest() {
    super("baas.did.verifiableclaim.issure.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190613");
  }

  /**
   * 颁发证书声明 */
  public BareClaim getBareClaim() {
    return this.bareClaim;
  }

  /**
   * 颁发证书声明 */
  public void setBareClaim(BareClaim bareClaim) {
    this.bareClaim = bareClaim;
  }

  /**
   * 由谁来颁发，该did必须为调用者自己或者自己代理的did */
  public String getIssuer() {
    return this.issuer;
  }

  /**
   * 由谁来颁发，该did必须为调用者自己或者自己代理的did */
  public void setIssuer(String issuer) {
    this.issuer = issuer;
  }

  /**
   * 为哪个did颁发 */
  public String getSubject() {
    return this.subject;
  }

  /**
   * 为哪个did颁发 */
  public void setSubject(String subject) {
    this.subject = subject;
  }
}
