//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.InitProductResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 售卖页面加载产品个性化内容，比如：类目、库存等，用于辅助用户选择。用户下单后参数会下发给产品方 */
public class InitProductRequest extends AntCloudProdRequest<InitProductResponse> {
  @NotNull
  private String businessAction;

  @NotNull
  private String businessContext;

  private String orderNo;

  @NotNull
  private String productCode;

  private String region;

  public InitProductRequest(String productInstanceId) {
    super("baas.ocp.product.init", "1.0", "Java-SDK-20190613", productInstanceId);
  }

  public InitProductRequest() {
    super("baas.ocp.product.init", "1.0", null);
    this.setSdkVersion("Java-SDK-20190613");
  }

  /**
   * 加载业务的场景 */
  public String getBusinessAction() {
    return this.businessAction;
  }

  /**
   * 加载业务的场景 */
  public void setBusinessAction(String businessAction) {
    this.businessAction = businessAction;
  }

  /**
   * 用于加载对应场景数据的上下文（JSON格式具体同产品方定义） */
  public String getBusinessContext() {
    return this.businessContext;
  }

  /**
   * 用于加载对应场景数据的上下文（JSON格式具体同产品方定义） */
  public void setBusinessContext(String businessContext) {
    this.businessContext = businessContext;
  }

  /**
   * 流水号用于业务串联，以及幂等 */
  public String getOrderNo() {
    return this.orderNo;
  }

  /**
   * 流水号用于业务串联，以及幂等 */
  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  /**
   * 产品码 全局唯一 */
  public String getProductCode() {
    return this.productCode;
  }

  /**
   * 产品码 全局唯一 */
  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  /**
   * 区域 */
  public String getRegion() {
    return this.region;
  }

  /**
   * 区域 */
  public void setRegion(String region) {
    this.region = region;
  }
}
