//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.CreateUserRelationResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 用户之间分销关系建立 */
public class CreateUserRelationRequest extends AntCloudProdRequest<CreateUserRelationResponse> {
  private String fromUserId;

  private String itemId;

  @NotNull
  private String shopId;

  @NotNull
  private String source;

  @NotNull
  private String userId;

  public CreateUserRelationRequest(String productInstanceId) {
    super("baas.distribution.user.relation.create", "1.0", "Java-SDK-20190613", productInstanceId);
  }

  public CreateUserRelationRequest() {
    super("baas.distribution.user.relation.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190613");
  }

  /**
   * 上级用户唯一标识 */
  public String getFromUserId() {
    return this.fromUserId;
  }

  /**
   * 上级用户唯一标识 */
  public void setFromUserId(String fromUserId) {
    this.fromUserId = fromUserId;
  }

  /**
   * 商品唯一标识 */
  public String getItemId() {
    return this.itemId;
  }

  /**
   * 商品唯一标识 */
  public void setItemId(String itemId) {
    this.itemId = itemId;
  }

  /**
   * 商户唯一标识 */
  public String getShopId() {
    return this.shopId;
  }

  /**
   * 商户唯一标识 */
  public void setShopId(String shopId) {
    this.shopId = shopId;
  }

  /**
   * 来源，微信朋友圈/微信小程序/支付宝小程序/H5/商户自有APP/其他 */
  public String getSource() {
    return this.source;
  }

  /**
   * 来源，微信朋友圈/微信小程序/支付宝小程序/H5/商户自有APP/其他 */
  public void setSource(String source) {
    this.source = source;
  }

  /**
   * 用户唯一标识 */
  public String getUserId() {
    return this.userId;
  }

  /**
   * 用户唯一标识 */
  public void setUserId(String userId) {
    this.userId = userId;
  }
}
