//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.BatchqueryMappingResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 批量查询商户下已映射的账户信息 */
public class BatchqueryMappingRequest extends AntCloudProdRequest<BatchqueryMappingResponse> {
  @NotNull
  private String bizid;

  @NotNull
  @Min(1)
  private Long pageNum;

  @NotNull
  @Min(1)
  private Long pageSize;

  public BatchqueryMappingRequest(String productInstanceId) {
    super("baas.account.mapping.batchquery", "1.0", "Java-SDK-20190613", productInstanceId);
  }

  public BatchqueryMappingRequest() {
    super("baas.account.mapping.batchquery", "1.0", null);
    this.setSdkVersion("Java-SDK-20190613");
  }

  /**
   * 要映射的链对应的唯一id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 要映射的链对应的唯一id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 查询页数 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询页数 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 每页大小 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页大小 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }
}
