//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 存证信息集合 */
public class NotaryTransaction {
  @NotNull
  private String content;

  @NotNull
  private String transactionHash;

  @NotNull
  private String type;

  /**
   * 如果存证类型为text, 则为存证内容
   * 如果存证类型为file,则为存证文件临时下载地址 */
  public String getContent() {
    return this.content;
  }

  /**
   * 如果存证类型为text, 则为存证内容
   * 如果存证类型为file,则为存证文件临时下载地址 */
  public void setContent(String content) {
    this.content = content;
  }

  /**
   * 链上存证哈希 */
  public String getTransactionHash() {
    return this.transactionHash;
  }

  /**
   * 链上存证哈希 */
  public void setTransactionHash(String transactionHash) {
    this.transactionHash = transactionHash;
  }

  /**
   * 存证类型 */
  public String getType() {
    return this.type;
  }

  /**
   * 存证类型 */
  public void setType(String type) {
    this.type = type;
  }
}
