/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mybatis.generator.api.IntrospectedTable;

public class PluginUtils {
    public static void classComment(List<String> javaDocLines, IntrospectedTable introspectedTable, String defaultRemarks, String suffix) {
        javaDocLines.clear();
        String remarks = PluginUtils.isEmpty(introspectedTable.getRemarks()) ? defaultRemarks : introspectedTable.getRemarks();
        remarks = remarks + " " + suffix;
        javaDocLines.add("/**");
        javaDocLines.add(" * " + remarks);
        javaDocLines.add(" * ");
        javaDocLines.add(" * @author " + System.getProperty("user.name"));
        javaDocLines.add(" */");
    }

    public static boolean existFile(String targetProject, String targetPackage, String fileName) {
        boolean rc;
        File project = new File(targetProject);
        if (!project.isDirectory()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(targetPackage, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(File.separatorChar);
        }
        File directory = new File(project, sb.toString());
        if (!directory.isDirectory() && !(rc = directory.mkdirs())) {
            return false;
        }
        File file = new File(directory, fileName);
        return file.exists();
    }

    public static String getString(Properties properties, String key, String defaultValue) {
        String property = properties.getProperty(key);
        return property == null || "".equals(property) ? defaultValue : property;
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static void setMethodValue(Object instance, String methodName, Object value, Class ... parameterTypes) {
        try {
            Class<?> type = instance.getClass();
            Method method = type.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            method.invoke(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

