/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.maven.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;

public class PluginUtils {
    public static ShellCallback shellCallback = new DefaultShellCallback(true);

    public static void classComment(List<String> javaDocLines, IntrospectedTable introspectedTable, String defaultRemarks, String suffix) {
        javaDocLines.clear();
        String remarks = PluginUtils.isEmpty(introspectedTable.getRemarks()) ? defaultRemarks : introspectedTable.getRemarks();
        remarks = remarks + " " + suffix;
        javaDocLines.add("/**");
        javaDocLines.add(" * " + remarks);
        javaDocLines.add(" * ");
        javaDocLines.add(" * @author @mbg.generated");
        javaDocLines.add(" */");
    }

    public static boolean existFile(String targetProject, String targetPackage, String fileName) {
        try {
            File directory = shellCallback.getDirectory(targetProject, targetPackage);
            File targetFile = new File(directory, fileName);
            return targetFile.exists();
        }
        catch (ShellException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean existFile(GeneratedXmlFile file) {
        return PluginUtils.existFile(file.getTargetProject(), file.getTargetPackage(), file.getFileName());
    }

    public static String getString(Properties properties, String key, String defaultValue) {
        String property = properties.getProperty(key);
        return property == null || "".equals(property) ? defaultValue : property;
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static void setMethodValue(Object instance, String methodName, Object value, Class ... parameterTypes) {
        try {
            Class<?> type = instance.getClass();
            Method method = type.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            method.invoke(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addLombokAnnotation(TopLevelClass topLevelClass) {
        topLevelClass.addAnnotation("@Getter");
        topLevelClass.addAnnotation("@Setter");
        topLevelClass.addAnnotation("@NoArgsConstructor");
        topLevelClass.addAnnotation("@AllArgsConstructor");
        topLevelClass.addImportedType("lombok.Getter");
        topLevelClass.addImportedType("lombok.Setter");
        topLevelClass.addImportedType("lombok.NoArgsConstructor");
        topLevelClass.addImportedType("lombok.AllArgsConstructor");
    }
}

