/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.maven.plugin;

import cn.caohongliang.mybatis.generator.maven.util.PluginUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class DomainLombokPlugin
extends PluginAdapter {
    private static final Pattern PATTERN = Pattern.compile("(?m)^.*$");
    public static boolean useSwagger = true;

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List javaDocLines = topLevelClass.getJavaDocLines();
        String defaultRemarks = topLevelClass.getType().getShortName();
        PluginUtils.classComment(javaDocLines, introspectedTable, defaultRemarks, " Entity");
        PluginUtils.addLombokAnnotation(topLevelClass);
        topLevelClass.addAnnotation("@Builder");
        topLevelClass.addImportedType("lombok.Builder");
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        List javaDocLines = field.getJavaDocLines();
        javaDocLines.clear();
        String remarks = PluginUtils.isEmpty(introspectedColumn.getRemarks()) ? field.getName() : introspectedColumn.getRemarks();
        Matcher matcher = PATTERN.matcher(remarks);
        javaDocLines.add("/**");
        String br = "<br/>";
        StringBuilder apiModelProperty = new StringBuilder("@ApiModelProperty(\"");
        while (matcher.find()) {
            String group = matcher.group();
            javaDocLines.add(" * " + group);
            apiModelProperty.append(group).append(br);
        }
        apiModelProperty.append("\")");
        javaDocLines.add(" */");
        int index = apiModelProperty.lastIndexOf(br);
        if (index != -1) {
            apiModelProperty = new StringBuilder(apiModelProperty.toString().replaceAll("<br/>\\s*\"\\)", "\")"));
        }
        if (useSwagger) {
            field.addAnnotation(apiModelProperty.toString());
            topLevelClass.addImportedType("io.swagger.annotations.ApiModelProperty");
        }
        return true;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }
}

