/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.maven.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

public class BaseColumnListPlugin
extends PluginAdapter {
    public boolean validate(List<String> list) {
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        int baseColumnListIndex = -1;
        int blobColumnListIndex = -1;
        List elements = document.getRootElement().getElements();
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            if (element instanceof TextElement) continue;
            XmlElement xmlElement = (XmlElement)element;
            if (this.matchXmlId(xmlElement, "Base_Column_List")) {
                baseColumnListIndex = i;
            }
            if (!this.matchXmlId(xmlElement, "Blob_Column_List")) continue;
            blobColumnListIndex = i;
        }
        if (baseColumnListIndex > 0) {
            ArrayList<XmlElement> tempList = new ArrayList<XmlElement>();
            tempList.add(this.makeElements(introspectedTable, "Base_Column_List_Alias", false));
            tempList.add(this.makeElements(introspectedTable, "Base_Column_List_Alias_Column_Prefix", true));
            elements.addAll(baseColumnListIndex + 1, tempList);
        }
        if (blobColumnListIndex > 0) {
            blobColumnListIndex = baseColumnListIndex > 0 ? blobColumnListIndex + 2 : blobColumnListIndex;
            ArrayList<XmlElement> tempList = new ArrayList<XmlElement>();
            tempList.add(this.makeElements(introspectedTable, "Blob_Column_List_Alias", false));
            tempList.add(this.makeElements(introspectedTable, "Blob_Column_List_Alias_Column_Prefix", true));
            elements.addAll(blobColumnListIndex + 1, tempList);
        }
        return true;
    }

    private boolean matchXmlId(XmlElement element, String idValue) {
        for (Attribute attribute : element.getAttributes()) {
            boolean match = "id".equals(attribute.getName()) && idValue.equals(attribute.getValue());
            if (!match) continue;
            return true;
        }
        return false;
    }

    private XmlElement makeElements(IntrospectedTable introspectedTable, String id, boolean hasColumnPrefix) {
        XmlElement answer = new XmlElement("sql");
        answer.addAttribute(new Attribute("id", id));
        this.context.getCommentGenerator().addComment(answer);
        StringBuilder sb = new StringBuilder();
        Iterator iter = introspectedTable.getNonBLOBColumns().iterator();
        while (iter.hasNext()) {
            String column = MyBatis3FormattingUtilities.getSelectListPhrase((IntrospectedColumn)((IntrospectedColumn)iter.next()));
            column = "${alias}." + column + (hasColumnPrefix ? " as ${columnPrefix}" + column : "");
            sb.append(column);
            if (iter.hasNext()) {
                sb.append(", ");
            }
            if (sb.length() <= 80) continue;
            answer.addElement((Element)new TextElement(sb.toString()));
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            answer.addElement((Element)new TextElement(sb.toString()));
        }
        return answer;
    }
}

