/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.maven.plugin;

import cn.caohongliang.mybatis.generator.maven.util.PluginUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.XMLMapperGenerator;
import org.mybatis.generator.internal.NullProgressCallback;

public class AutoGenXmlPlugin
extends PluginAdapter {
    private GeneratedXmlFile customFile;
    private List<String> warnings;

    public boolean validate(List<String> warnings) {
        this.warnings = warnings;
        return true;
    }

    public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
        this.customFile = sqlMap;
        return !PluginUtils.existFile(this.customFile);
    }

    public List<GeneratedXmlFile> contextGenerateAdditionalXmlFiles(IntrospectedTable introspectedTable) {
        if (this.customFile == null) {
            return null;
        }
        Document autoGenDocument = this.getDocument(introspectedTable);
        String autoGenFileName = "AutoGen" + this.customFile.getFileName();
        String targetPackage = this.customFile.getTargetPackage() + ".autogen";
        GeneratedXmlFile autoGen = new GeneratedXmlFile(autoGenDocument, autoGenFileName, targetPackage, this.customFile.getTargetProject(), false, this.context.getXmlFormatter());
        Document customDocument = this.getCustomFileDocument();
        XmlElement autoRootElement = customDocument.getRootElement();
        XmlElement customRootElement = new XmlElement(autoRootElement.getName());
        for (Attribute attribute : autoRootElement.getAttributes()) {
            customRootElement.addAttribute(attribute);
        }
        customRootElement.addElement((Element)new TextElement("<!-- \u81ea\u5b9a\u4e49SQL\u5199\u5728\u8fd9\u4e2a\u6587\u4ef6\u4e2d -->"));
        autoGenDocument.setRootElement(autoRootElement);
        customDocument.setRootElement(customRootElement);
        return Collections.singletonList(autoGen);
    }

    private Document getCustomFileDocument() {
        try {
            Class<?> clazz = this.customFile.getClass();
            Field field = clazz.getDeclaredField("document");
            field.setAccessible(true);
            return (Document)field.get(this.customFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Document getDocument(IntrospectedTable introspectedTable) {
        XMLMapperGenerator xmlMapperGenerator = new XMLMapperGenerator();
        xmlMapperGenerator.setContext(this.context);
        xmlMapperGenerator.setIntrospectedTable(introspectedTable);
        xmlMapperGenerator.setProgressCallback((ProgressCallback)new NullProgressCallback());
        xmlMapperGenerator.setWarnings(this.warnings);
        return xmlMapperGenerator.getDocument();
    }
}

