/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.maven;

import cn.caohongliang.mybatis.generator.maven.MavenLogFactory;
import cn.caohongliang.mybatis.generator.maven.MavenProgressCallback;
import cn.caohongliang.mybatis.generator.maven.MavenShellCallback;
import cn.caohongliang.mybatis.generator.maven.plugin.AutoGenXmlPlugin;
import cn.caohongliang.mybatis.generator.maven.plugin.BaseColumnListPlugin;
import cn.caohongliang.mybatis.generator.maven.plugin.DomainLombokPlugin;
import cn.caohongliang.mybatis.generator.maven.plugin.ParentMapperPlugin;
import cn.caohongliang.mybatis.generator.maven.util.PluginUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.ClassloaderUtility;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.logging.AbstractLogFactory;
import org.mybatis.generator.logging.LogFactory;

@org.apache.maven.plugins.annotations.Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class MyBatisGeneratorMojo
extends AbstractMojo {
    private ThreadLocal<ClassLoader> savedClassloader = new ThreadLocal();
    private List<Class<? extends Plugin>> defaultPluginTypes = Arrays.asList(DomainLombokPlugin.class, BaseColumnListPlugin.class, AutoGenXmlPlugin.class, ParentMapperPlugin.class);
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/mybatis-generator", required=true)
    private File outputDirectory;
    @Parameter(property="mybatis.generator.configurationFile", defaultValue="${project.basedir}/src/main/resources/generatorConfig.xml", required=true)
    private File configurationFile;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="true")
    private boolean overwrite;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean includeCompileDependencies;
    @Parameter(defaultValue="false")
    private boolean includeAllDependencies;
    @Parameter(defaultValue="true")
    private boolean domainUseSwagger;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"MyBatis generator is skipped.");
            return;
        }
        this.saveClassLoader();
        LogFactory.setLogFactory((AbstractLogFactory)new MavenLogFactory((Mojo)this));
        this.calculateClassPath();
        List resources = this.project.getResources();
        ArrayList<String> resourceDirectories = new ArrayList<String>();
        for (Resource resource : resources) {
            resourceDirectories.add(resource.getDirectory());
        }
        ClassLoader cl = ClassloaderUtility.getCustomClassloader(resourceDirectories);
        ObjectFactory.addExternalClassLoader((ClassLoader)cl);
        if (this.configurationFile == null) {
            throw new MojoExecutionException(Messages.getString((String)"RuntimeError.0"));
        }
        ArrayList warnings = new ArrayList();
        if (!this.configurationFile.exists()) {
            throw new MojoExecutionException(Messages.getString((String)"RuntimeError.1", (String)this.configurationFile.toString()));
        }
        try {
            ConfigurationParser cp = new ConfigurationParser(this.project.getProperties(), warnings);
            Configuration config = cp.parseConfiguration(this.configurationFile);
            this.addDefaultPlugins(config);
            this.setPluginsConfig();
            MavenShellCallback callback = new MavenShellCallback(this, this.overwrite);
            PluginUtils.shellCallback = callback;
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            myBatisGenerator.generate((ProgressCallback)new MavenProgressCallback(this.getLog(), this.verbose));
        }
        catch (XMLParserException e) {
            for (String error : e.getErrors()) {
                this.getLog().error((CharSequence)error);
            }
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException | SQLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            for (String error : e.getErrors()) {
                this.getLog().error((CharSequence)error);
            }
            throw new MojoExecutionException(e.getMessage());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (String error : warnings) {
            this.getLog().warn((CharSequence)error);
        }
        if (this.project != null && this.outputDirectory != null && this.outputDirectory.exists()) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            resource.addInclude("**/*.xml");
            this.project.addResource(resource);
        }
        this.restoreClassLoader();
    }

    private void setPluginsConfig() {
        DomainLombokPlugin.useSwagger = this.domainUseSwagger;
    }

    private void addDefaultPlugins(Configuration config) {
        config.getContexts().forEach(context -> this.defaultPluginTypes.forEach(pluginType -> {
            PluginConfiguration pluginConfiguration = new PluginConfiguration();
            pluginConfiguration.setConfigurationType(pluginType.getName());
            context.addPluginConfiguration(pluginConfiguration);
        }));
    }

    private void calculateClassPath() throws MojoExecutionException {
        if (this.includeCompileDependencies || this.includeAllDependencies) {
            try {
                HashSet entries = new HashSet();
                if (this.includeCompileDependencies) {
                    entries.addAll(this.project.getCompileClasspathElements());
                }
                if (this.includeAllDependencies) {
                    entries.addAll(this.project.getTestClasspathElements());
                }
                entries.remove(this.project.getBuild().getOutputDirectory());
                entries.remove(this.project.getBuild().getTestOutputDirectory());
                ClassLoader contextClassLoader = ClassloaderUtility.getCustomClassloader(entries);
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Dependency Resolution Required", (Exception)((Object)e));
            }
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    private void saveClassLoader() {
        this.savedClassloader.set(Thread.currentThread().getContextClassLoader());
    }

    private void restoreClassLoader() {
        Thread.currentThread().setContextClassLoader(this.savedClassloader.get());
    }
}

