/*
 * Decompiled with CFR 0.152.
 */
package com.bjdd.core.mvc.render;

import com.bjdd.core.mvc.render.BaseResultCode;
import com.bjdd.core.mvc.render.ResultEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Page;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
public class Render<T>
implements Serializable {
    private String msg;
    private T data;
    private int code;
    private Boolean error;
    private Long timestamp;
    private static Map map;
    @JsonIgnore
    private transient Map<Class<?>, Set<String>> includes;
    @JsonIgnore
    private transient Map<Class<?>, Set<String>> excludes;

    public String getMsg() {
        return this.msg;
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public Boolean getError() {
        return this.error;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public static <T> Render<T> fail(int code, String message) {
        Render<T> msg = new Render<T>();
        msg.msg = message;
        msg.code(code);
        msg.error(true);
        return super.putTimeStamp();
    }

    public static <T> Render<T> fail(String message) {
        Render<T> msg = new Render<T>();
        msg.msg = message;
        msg.code(ResultEnum.EXCEPTION.val());
        msg.error(true);
        return super.putTimeStamp();
    }

    public static <T> Render<T> fail(ResultEnum resultCode) {
        Render<T> msg = new Render<T>();
        msg.msg = resultCode.msg();
        msg.code(resultCode.val());
        msg.error(true);
        return super.putTimeStamp();
    }

    public static <T> Render<T> fail(BaseResultCode resultCode) {
        return super.putTimeStamp().error(true).msg(resultCode.getMsg()).code(resultCode.getCode());
    }

    public static <T> Render<T> ok() {
        return Render.ok("\u6210\u529f");
    }

    private Render<T> putTimeStamp() {
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public static <T> Render<T> ok(T data) {
        return super.putTimeStamp().error(false).msg(ResultEnum.SUCCESS.msg()).code(ResultEnum.SUCCESS.val());
    }

    public static <T> Render<T> ok(String msg) {
        return super.putTimeStamp().error(false).msg(msg).code(ResultEnum.SUCCESS.val());
    }

    public static <T> Render<T> ok(T data, String msg) {
        return super.putTimeStamp().error(false).msg(msg).code(ResultEnum.SUCCESS.val());
    }

    public static <T> Render<T> ok(T data, BaseResultCode resultCode) {
        return super.putTimeStamp().error(false).msg(resultCode.getMsg()).code(resultCode.getCode());
    }

    public static <T> Render<T> ok(BaseResultCode resultCode) {
        return super.putTimeStamp().error(false).msg(resultCode.getMsg()).code(resultCode.getCode());
    }

    public static Map okMap(Object data) {
        map = new HashMap();
        map.put("data", data);
        map.put("error", false);
        map.put("code", ResultEnum.SUCCESS.val());
        map.put("msg", ResultEnum.SUCCESS.msg());
        map.put("timestamp", System.currentTimeMillis());
        return map;
    }

    public static Map failMap(String msg) {
        map = new HashMap();
        map.put("data", null);
        map.put("error", true);
        map.put("code", ResultEnum.EXCEPTION.val());
        map.put("msg", msg);
        map.put("timestamp", System.currentTimeMillis());
        return map;
    }

    public static Map okPage(Page data) {
        Map mapPage = Render.okMap(data);
        mapPage.put("data", data.getContent());
        mapPage.put("total", data.getTotalElements());
        return mapPage;
    }

    public static Map okPage(List data, long total) {
        Map mapPage = Render.okMap(data);
        mapPage.put("total", total);
        return mapPage;
    }

    public static Map failMap(ResultEnum resultCode) {
        map = new HashMap();
        map.put("data", null);
        map.put("error", true);
        map.put("code", resultCode.val());
        map.put("msg", resultCode.msg());
        map.put("timestamp", System.currentTimeMillis());
        return map;
    }

    public Render<T> data(T data) {
        this.data = data;
        return this;
    }

    public Render<T> code(int code) {
        this.code = code;
        return this;
    }

    public Render<T> error(Boolean error) {
        this.error = error;
        return this;
    }

    public Render<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public Render<T> include(Class<?> type, String ... fields) {
        return this.include(type, Arrays.asList(fields));
    }

    public Render<T> include(Class<?> type, Collection<String> fields) {
        if (this.includes == null) {
            this.includes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        fields.forEach(field -> {
            if (field.contains(".")) {
                String[] tmp = field.split("[.]", 2);
                try {
                    Field field1 = type.getDeclaredField(tmp[0]);
                    if (field1 != null) {
                        this.include(field1.getType(), tmp[1]);
                    }
                }
                catch (Throwable throwable) {}
            } else {
                this.getStringListFromMap(this.includes, type).add((String)field);
            }
        });
        return this;
    }

    public Render<T> exclude(Class type, Collection<String> fields) {
        if (this.excludes == null) {
            this.excludes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        fields.forEach(field -> {
            if (field.contains(".")) {
                String[] tmp = field.split("[.]", 2);
                try {
                    Field field1 = type.getDeclaredField(tmp[0]);
                    if (field1 != null) {
                        this.exclude(field1.getType(), tmp[1]);
                    }
                }
                catch (Throwable throwable) {}
            } else {
                this.getStringListFromMap(this.excludes, type).add((String)field);
            }
        });
        return this;
    }

    public Render<T> exclude(Collection<String> fields) {
        if (this.excludes == null) {
            this.excludes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        if (this.getData() == null) {
            return this;
        }
        Class<?> type = this.getData().getClass();
        this.exclude(type, fields);
        return this;
    }

    public Render<T> include(Collection<String> fields) {
        if (this.includes == null) {
            this.includes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        if (this.getData() == null) {
            return this;
        }
        Class<?> type = this.getData().getClass();
        this.include(type, fields);
        return this;
    }

    public Render<T> exclude(Class type, String ... fields) {
        return this.exclude(type, Arrays.asList(fields));
    }

    public Render<T> exclude(String ... fields) {
        return this.exclude(Arrays.asList(fields));
    }

    public Render<T> include(String ... fields) {
        return this.include(Arrays.asList(fields));
    }

    protected Set<String> getStringListFromMap(Map<Class<?>, Set<String>> map, Class type) {
        return map.computeIfAbsent(type, k -> new HashSet());
    }
}

