/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.test.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class PushbackBodyClientHttpResponseWrapper
implements ClientHttpResponse {
    private final ClientHttpResponse response;
    private Charset defaultCharset = Charset.forName("UTF-8");
    private PushbackInputStream pushbackInputStream;
    private final int readlimit;

    public PushbackBodyClientHttpResponseWrapper(ClientHttpResponse response) {
        this.response = response;
        this.readlimit = 0xA00000;
    }

    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    public InputStream getBody() throws IOException {
        return this.pushbackInputStream != null ? this.pushbackInputStream : this.response.getBody();
    }

    public String readBody() throws IOException {
        InputStream body = this.response.getBody();
        if (body == null) {
            return null;
        }
        if (body.markSupported()) {
            body.mark(this.readlimit);
            String bodyString = StreamUtils.copyToString((InputStream)body, (Charset)this.defaultCharset);
            body.reset();
            return bodyString;
        }
        this.pushbackInputStream = new PushbackInputStream(body, this.readlimit);
        String bodyString = StreamUtils.copyToString((InputStream)this.pushbackInputStream, (Charset)this.defaultCharset);
        this.pushbackInputStream.unread(bodyString.getBytes(this.defaultCharset));
        return bodyString;
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.response.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.response.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.response.getStatusText();
    }

    public void close() {
        this.response.close();
    }
}

