/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.test.client;

import cn.bestwu.test.client.PushbackBodyClientHttpResponseWrapper;
import cn.bestwu.test.client.RequestCallback;
import cn.bestwu.test.client.UTF8AllEncompassingFormHttpMessageConverter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class CustomRestTemplate
extends RestTemplate {
    private boolean print;
    private static Charset defaultCharset = Charset.forName("UTF-8");
    private RequestCallback requestCallback;

    public void setPrint(boolean print) {
        this.print = print;
    }

    public CustomRestTemplate() {
        this(null, null);
    }

    public CustomRestTemplate(String username, String password) {
        this.addAuthentication(username, password);
        this.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) {
            }
        });
        boolean romePresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)RestTemplate.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean jackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)RestTemplate.class.getClassLoader());
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter(defaultCharset));
        messageConverters.add(new ResourceHttpMessageConverter());
        messageConverters.add(new SourceHttpMessageConverter());
        messageConverters.add((Object)new UTF8AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add(new AtomFeedHttpMessageConverter());
            messageConverters.add(new RssChannelHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            messageConverters.add(new MappingJackson2XmlHttpMessageConverter());
        } else if (jaxb2Present) {
            messageConverters.add(new Jaxb2RootElementHttpMessageConverter());
        }
        if (jackson2Present) {
            messageConverters.add(new MappingJackson2HttpMessageConverter());
        } else if (gsonPresent) {
            messageConverters.add(new GsonHttpMessageConverter());
        }
        this.setMessageConverters(messageConverters);
    }

    private void addAuthentication(String username, String password) {
        if (username == null) {
            return;
        }
        ArrayList<BasicAuthorizationInterceptor> interceptors = new ArrayList<BasicAuthorizationInterceptor>(1);
        interceptors.add(new BasicAuthorizationInterceptor(username, password));
        this.setInterceptors(interceptors);
    }

    public void setRequestCallback(RequestCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    protected <T> org.springframework.web.client.RequestCallback httpEntityCallback(Object requestBody) {
        return new HttpEntityRequestCallback(requestBody);
    }

    protected <T> org.springframework.web.client.RequestCallback httpEntityCallback(Object requestBody, Type responseType) {
        return new HttpEntityRequestCallback(requestBody, responseType);
    }

    /*
     * Loose catch block
     */
    protected <T> T doExecute(URI url, HttpMethod method, org.springframework.web.client.RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        Assert.notNull((Object)url, (String)"'url' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        try (ClientHttpResponse response = null;){
            ClientHttpRequest request = this.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            HttpHeaders requestHeaders = request.getHeaders();
            response = request.execute();
            if (this.print && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"------------------------------");
                this.logger.debug((Object)"requestHeaders:");
                for (Object key : requestHeaders.keySet()) {
                    this.logger.debug((Object)((String)key + " : " + requestHeaders.get(key)));
                }
                this.logger.debug((Object)"------------------------------");
            }
            HttpHeaders responseHeaders = response.getHeaders();
            if (this.print && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"------------------------------");
                this.logger.debug((Object)"responseHeaders:");
                for (String key : responseHeaders.keySet()) {
                    this.logger.debug((Object)(key + " : " + responseHeaders.get((Object)key)));
                }
                this.logger.debug((Object)"------------------------------");
            }
            this.handleResponse(url, method, response);
            if (responseExtractor != null) {
                Object key;
                if (this.print && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"------------------------------");
                    response = new PushbackBodyClientHttpResponseWrapper(response);
                    this.logger.debug((Object)("responseBody: \n" + ((PushbackBodyClientHttpResponseWrapper)response).readBody()));
                    this.logger.debug((Object)"------------------------------");
                }
                try {
                    key = responseExtractor.extractData(response);
                }
                catch (Exception e) {
                    ResponseEntity responseEntity;
                    block17: {
                        this.logger.warn((Object)"\u89e3\u6790response body\u5931\u8d25");
                        responseEntity = new ResponseEntity(null, (MultiValueMap)response.getHeaders(), response.getStatusCode());
                        if (response == null) break block17;
                        response.close();
                    }
                    return (T)responseEntity;
                }
                return (T)key;
            }
            T t = null;
            return t;
            {
                catch (IOException ex) {
                    throw new ResourceAccessException("I/O error on " + method.name() + " request for \"" + url + "\":" + ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        org.springframework.web.client.RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return (T)this.execute(url, HttpMethod.PUT, requestCallback, (ResponseExtractor)responseExtractor, new Object[]{null, null, uriVariables});
    }

    public <T> ResponseEntity<T> putForEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        org.springframework.web.client.RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.PUT, requestCallback, responseExtractor, new Object[]{null, uriVariables});
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Object ... uriVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, new Object[]{null, uriVariables});
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Map<String, ?> urlVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, new Object[]{null, urlVariables});
    }

    private class HttpEntityRequestCallback
    extends AcceptHeaderRequestCallback {
        private final HttpEntity<?> requestEntity;

        private HttpEntityRequestCallback(Object requestBody) {
            this(requestBody, (Type)null);
        }

        private HttpEntityRequestCallback(Object requestBody, Type responseType) {
            super(responseType);
            this.requestEntity = requestBody instanceof HttpEntity ? (HttpEntity)requestBody : (requestBody != null ? new HttpEntity(requestBody) : HttpEntity.EMPTY);
        }

        @Override
        public void doWithRequest(ClientHttpRequest httpRequest) throws IOException {
            super.doWithRequest(httpRequest);
            if (CustomRestTemplate.this.requestCallback != null) {
                CustomRestTemplate.this.requestCallback.doWithRequest(httpRequest, this.requestEntity);
            }
            if (!this.requestEntity.hasBody()) {
                HttpHeaders httpHeaders = httpRequest.getHeaders();
                HttpHeaders requestHeaders = this.requestEntity.getHeaders();
                if (!requestHeaders.isEmpty()) {
                    httpHeaders.putAll((Map)requestHeaders);
                }
                if (httpHeaders.getContentLength() < 0L) {
                    httpHeaders.setContentLength(0L);
                }
            } else {
                Object requestBody = this.requestEntity.getBody();
                Class<?> requestBodyClass = requestBody.getClass();
                Class<?> requestBodyType = this.requestEntity instanceof RequestEntity ? ((RequestEntity)this.requestEntity).getType() : requestBodyClass;
                HttpHeaders requestHeaders = this.requestEntity.getHeaders();
                MediaType requestContentType = requestHeaders.getContentType();
                for (HttpMessageConverter messageConverter : CustomRestTemplate.this.getMessageConverters()) {
                    if (messageConverter instanceof GenericHttpMessageConverter) {
                        GenericHttpMessageConverter genericMessageConverter = (GenericHttpMessageConverter)messageConverter;
                        if (!genericMessageConverter.canWrite(requestBodyType, requestBodyClass, requestContentType)) continue;
                        if (!requestHeaders.isEmpty()) {
                            httpRequest.getHeaders().putAll((Map)requestHeaders);
                        }
                        if (CustomRestTemplate.this.logger.isDebugEnabled()) {
                            if (requestContentType != null) {
                                CustomRestTemplate.this.logger.debug((Object)("Writing [" + requestBody + "] as \"" + requestContentType + "\" using [" + messageConverter + "]"));
                            } else {
                                CustomRestTemplate.this.logger.debug((Object)("Writing [" + requestBody + "] using [" + messageConverter + "]"));
                            }
                        }
                        genericMessageConverter.write(requestBody, requestBodyType, requestContentType, (HttpOutputMessage)httpRequest);
                        return;
                    }
                    if (!messageConverter.canWrite(requestBodyClass, requestContentType)) continue;
                    if (!requestHeaders.isEmpty()) {
                        httpRequest.getHeaders().putAll((Map)requestHeaders);
                    }
                    if (CustomRestTemplate.this.logger.isDebugEnabled()) {
                        if (requestContentType != null) {
                            CustomRestTemplate.this.logger.debug((Object)("Writing [" + requestBody + "] as \"" + requestContentType + "\" using [" + messageConverter + "]"));
                        } else {
                            CustomRestTemplate.this.logger.debug((Object)("Writing [" + requestBody + "] using [" + messageConverter + "]"));
                        }
                    }
                    messageConverter.write(requestBody, requestContentType, (HttpOutputMessage)httpRequest);
                    return;
                }
                String message = "Could not write request: no suitable HttpMessageConverter found for request type [" + requestBodyClass.getName() + "]";
                if (requestContentType != null) {
                    message = message + " and content type [" + requestContentType + "]";
                }
                throw new RestClientException(message);
            }
        }
    }

    private class AcceptHeaderRequestCallback
    implements org.springframework.web.client.RequestCallback {
        private final Type responseType;

        private AcceptHeaderRequestCallback(Type responseType) {
            this.responseType = responseType;
        }

        public void doWithRequest(ClientHttpRequest request) throws IOException {
            if (this.responseType != null) {
                Class responseClass = null;
                if (this.responseType instanceof Class) {
                    responseClass = (Class)this.responseType;
                }
                ArrayList<MediaType> allSupportedMediaTypes = new ArrayList<MediaType>();
                for (HttpMessageConverter converter : CustomRestTemplate.this.getMessageConverters()) {
                    GenericHttpMessageConverter genericConverter;
                    if (responseClass != null) {
                        if (!converter.canRead(responseClass, null)) continue;
                        allSupportedMediaTypes.addAll(this.getSupportedMediaTypes(converter));
                        continue;
                    }
                    if (!(converter instanceof GenericHttpMessageConverter) || !(genericConverter = (GenericHttpMessageConverter)converter).canRead(this.responseType, null, null)) continue;
                    allSupportedMediaTypes.addAll(this.getSupportedMediaTypes(converter));
                }
                if (!allSupportedMediaTypes.isEmpty()) {
                    MediaType.sortBySpecificity(allSupportedMediaTypes);
                    if (CustomRestTemplate.this.logger.isDebugEnabled()) {
                        CustomRestTemplate.this.logger.debug((Object)("Setting request Accept header to " + allSupportedMediaTypes));
                    }
                    request.getHeaders().setAccept(allSupportedMediaTypes);
                }
            }
        }

        private List<MediaType> getSupportedMediaTypes(HttpMessageConverter<?> messageConverter) {
            List supportedMediaTypes = messageConverter.getSupportedMediaTypes();
            ArrayList<MediaType> result = new ArrayList<MediaType>(supportedMediaTypes.size());
            for (MediaType supportedMediaType : supportedMediaTypes) {
                if (supportedMediaType.getCharset() != null) {
                    supportedMediaType = new MediaType(supportedMediaType.getType(), supportedMediaType.getSubtype());
                }
                result.add(supportedMediaType);
            }
            return result;
        }
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String username;
        private final String password;

        BasicAuthorizationInterceptor(String username, String password) {
            this.username = username;
            this.password = password == null ? "" : password;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            String token = Base64Utils.encodeToString((byte[])(this.username + ":" + this.password).getBytes(defaultCharset));
            request.getHeaders().add("Authorization", "Basic " + token);
            return execution.execute(request, body);
        }
    }
}

