package com.taobao.pamirs.schedule.taskmanager;

import java.util.List;

import com.taobao.pamirs.schedule.TaskItemDefine;


/**
 * Ŀͻ˽ӿڣлݿʵ֣лConfigServerʵ
 *
 * @author xuannan
 */
public interface IScheduleDataManager {

  public long getSystemTime();

  /**
   * װصǰserverҪݶ
   *
   * @param taskType 
   * @param uuid ǰserverUUID
   */
  public List<TaskItemDefine> reloadDealTaskItem(String taskType, String uuid) throws Exception;

  /**
   * װеϢ
   */
  public List<ScheduleTaskItem> loadAllTaskItem(String taskType) throws Exception;

  /**
   * ͷԼѳ֣Ķ
   */
  public void releaseDealTaskItem(String taskType, String uuid) throws Exception;

  /**
   * ȡһ͵Ĵ
   */
  public int queryTaskItemCount(String taskType) throws Exception;

  /**
   * װϢ
   */
  public ScheduleTaskType loadTaskTypeBaseInfo(String taskType) throws Exception;

  /**
   * ѾڵĵȷϢ
   */
  public int clearExpireScheduleServer(String taskType, long expireTime) throws Exception;

  /**
   * ϢѾڵʱ
   */
  public int clearTaskItem(String taskType, List<String> serverList) throws Exception;

  /**
   * ȡеЧϢ
   */
  public List<ScheduleServer> selectAllValidScheduleServer(String taskType) throws Exception;

  public List<String> loadScheduleServerNames(String taskType) throws Exception;

  /**
   * ·Item
   */
  public void assignTaskItem(String taskType, String currentUuid, int maxNumOfOneServer,
      List<String> serverList) throws Exception;

  /**
   * Ϣ
   */
  public boolean refreshScheduleServer(ScheduleServer server) throws Exception;

  /**
   * ע
   */
  public void registerScheduleServer(ScheduleServer server) throws Exception;

  /**
   * ע
   */
  public void unRegisterScheduleServer(String taskType, String serverUUID) throws Exception;

  /**
   * ѾڵOWN_SIGNԶɵ
   *
   * @param baseTaskType 
   * @param serverUUID 
   * @param expireDateInternal ʱ䣬Ϊλ
   */
  public void clearExpireTaskTypeRunningInfo(String baseTaskType, String serverUUID,
      double expireDateInternal) throws Exception;

  public boolean isLeader(String uuid, List<String> serverList);

  public void pauseAllServer(String baseTaskType) throws Exception;

  public void resumeAllServer(String baseTaskType) throws Exception;

  public List<ScheduleTaskType> getAllTaskTypeBaseInfo() throws Exception;

  /**
   * һ͵Ϣ
   */
  public void clearTaskType(String baseTaskType) throws Exception;

  /**
   * һµ
   */
  public void createBaseTaskType(ScheduleTaskType baseTaskType) throws Exception;

  public void updateBaseTaskType(ScheduleTaskType baseTaskType) throws Exception;

  public List<ScheduleTaskTypeRunningInfo> getAllTaskTypeRunningInfo(String baseTaskType)
      throws Exception;

  /**
   * ɾһ
   */
  public void deleteTaskType(String baseTaskType) throws Exception;

  /**
   * ѯǰȷ
   */
  public List<ScheduleServer> selectScheduleServer(String baseTaskType, String ownSign, String ip,
      String orderStr)
      throws Exception;

  /**
   * ѯȷʷ¼
   */
  public List<ScheduleServer> selectHistoryScheduleServer(String baseTaskType, String ownSign,
      String ip, String orderStr)
      throws Exception;

  public List<ScheduleServer> selectScheduleServerByManagerFactoryUUID(String factoryUUID)
      throws Exception;

  /**
   * עе CurrentSeverRequestServer
   */
  public void createScheduleTaskItem(ScheduleTaskItem[] taskItems) throws Exception;

  /**
   * ״̬ʹϢ
   */
  public void updateScheduleTaskItemStatus(String taskType, String taskItem,
      ScheduleTaskItem.TaskItemSts sts, String message) throws Exception;

  /**
   * ɾ
   */
  public void deleteScheduleTaskItem(String taskType, String taskItem) throws Exception;

  /**
   * ʼȵϢ;̬Ϣ
   */
  public void initialRunningInfo4Static(String baseTaskType, String ownSign, String uuid)
      throws Exception;

  public void initialRunningInfo4Dynamic(String baseTaskType, String ownSign) throws Exception;

  /**
   * ϢǷʼɹ
   */
  public boolean isInitialRunningInfoSucuss(String baseTaskType, String ownSign) throws Exception;

  public void setInitialRunningInfoSucuss(String baseTaskType, String taskType, String uuid)
      throws Exception;

  public String getLeader(List<String> serverList);

  public long updateReloadTaskItemFlag(String taskType) throws Exception;

  public long getReloadTaskItemFlag(String taskType) throws Exception;

}
