package cn.bestwu.gradle.profile.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction
import org.yaml.snakeyaml.DumperOptions
import org.yaml.snakeyaml.Yaml

/**
 * 激活特定Profile
 *
 * @author Peter Wu
 */
class ProfileTask extends DefaultTask {

    @Input
    String active = 'alpha'

    @TaskAction
    run() {
        project.version = ('unspecified' == project.version ? project.parent.version : project.version) + '.' + active.toUpperCase()

        if (project.profile.yml) {
            def ymlFile = new File(project.profile.source)
            if (ymlFile.exists()) {
                def dumperOptions = new DumperOptions()
                dumperOptions.setPrettyFlow(true)
                dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK)
                def yaml = new Yaml(dumperOptions)

                final iterable = yaml.loadAll(ymlFile.newDataInputStream())
                def list = iterable.asList()
                final Map defaut = list.first() as Map
                defaut.put('spring.profiles.active', active)
                yaml.dumpAll(list.iterator(), ymlFile.newWriter(project.profile.encoding))
            }
        }
        project.profile.closure.call(active)
    }

}